import argparse

print('Parsing args')

parser = argparse.ArgumentParser()
parser.add_argument("--model_name_or_path", type=str, default="roberta-base")
parser.add_argument("--dataset", type=str, default="mrpc")
parser.add_argument("--task", type=str, default="mrpc")
parser.add_argument("--bs", type=int, default=32)
parser.add_argument('--adapter', choices=['LoRA', 'LoCA', 'FourierFT', 'DoRA', 'AdaLoRA'],
                        default='LoCA')
parser.add_argument("--hidden_dropout_prob", type=float, default=0.1)
parser.add_argument("--num_epochs", type=int, default=50)
parser.add_argument("--n_frequency", type=int, default=1000)
parser.add_argument("--head_lr", type=float, default=5e-4)
parser.add_argument("--frequency_lr", type=float, default=5e-4)
parser.add_argument("--lora_r", type=int, default=8)
parser.add_argument("--lora_alpha", type=int, default=8)
parser.add_argument("--lora_dropout", type=float, default=0)
parser.add_argument("--location_lr", type=float, default=1e-4)
parser.add_argument("--loca_dct_mode", type=str, default="default")
parser.add_argument("--learn_location_iter", type=int, default=300)
parser.add_argument("--max_length", type=int, default=512)
parser.add_argument("--weight_decay", type=float, default=0.0)
parser.add_argument("--warm_step", type=float, default=0.06)
parser.add_argument("--train_ratio", type=float, default=1)
parser.add_argument("--scale", type=float, default=1)
parser.add_argument("--loca_dropout", type=float, default=0.)
parser.add_argument("--seed", type=int, default=00000)
parser.add_argument("--eval_steps", type=int, default=None)

def get_args():
    return parser.parse_args()